/*
*******************************************************************************
*
* File:		pxctbeh.h
* Description:  Function declarations for completer target behavior
* Author: 	Henrik Liebau
* Created: 	05 Apr 2000, 09:24:05
* Modified:     Wed Jun  7 18:22:35 2000 by Henrik Liebau, BVS R&D
* Language:	C/C++ Include File
* Package:	PCI-X Protocol Permutator&Randomizer 
* Status: 	
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/
 
#ifndef __pxctbeh_H__
#define __pxctbeh_H__

/* include type definitions, if not already done */
#ifndef __pxdef_H__
#include <pxdef.h>
#endif /* defined __pxdef_H__ */

/* include type definitions, if not already done */
#ifndef __pxbehdef_H__
#include <pxbehdef.h>
#endif /* defined __pxbehdef_H__ */

/* make sure this also runs in C++ programs */
#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------*
 * BestXPprCTDefaultSet 
 * CLI abbrev.: pprctdefaultset
 *
 * Set all settings concerning the completer target to default values 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCTDefaultSet (	       /* @pprctdefaultset */
  bx_handletype handle
  );

/*----------------------------------------------------------------------------*
 * BestXPprCTBehPermDefaultSet 
 * CLI abbrev.: pprctbehpermdefaultset
 *
 * Set PPR Ri Behavior perm settings to defaults 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCTBehPermDefaultSet (    /* @pprctbehpermdefaultset */
  bx_handletype handle
  );

/*----------------------------------------------------------------------------*
 * BestXPprCTBehPermSet 
 * CLI abbrev.: pprctbehpermset prop=<permprop> val = <value>
 *
 * Set PPR Behavior completer target settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCTBehPermSet (	       /* @pprctbehpermset */
  bx_handletype handle,
  bxppr_behpermtype permprop,			       /* @prop */
  bx_int32 value				       /* @val */
  );

/*----------------------------------------------------------------------------*
 * BestXPprCTBehPermGet 
 * CLI abbrev.: pprctbehpermget prop=<permprop> val = <value>
 *
 * Get PPR Behavior completer target settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCTBehPermGet (	       /* @pprctbehpermget */
  bx_handletype handle,
  bxppr_behpermtype permprop,			       /* @prop */
  bx_int32 * pValue				       /* #RETURN "%08lx\\h" */
  );

/*----------------------------------------------------------------------------*
 * BestXPprCTBehListDefaultSet 
 * CLI abbrev.: pprctbehlistdefaultset beh = <behavior>
 *
 * set variation list for completer target behaviors to default 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCTBehListDefaultSet (    /* @pprctbehlistdefaultset */
  bx_handletype handle,
  bx_ctbehtype behavior				       /* @beh */
  );

/*----------------------------------------------------------------------------*
 * BestXPprCTBehListSet 
 * CLI abbrev.: pprctbehlistset beh = <behavior> list = <list>
 *
 * set variation list for completer target behaviors 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCTBehListSet (	       /* @pprctbehlistset */
  bx_handletype handle,
  bx_ctbehtype behavior,			       /* @beh */
  bxppr_listtype list				       /* @list */
  );

/*----------------------------------------------------------------------------*
 * BestXPprCTBehListGet 
 * CLI abbrev.: pprctbehlistget beh = <behavior> list = <list>
 *
 * get variation list for completer target behaviors 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCTBehListGet (	       /* @pprctbehlistget */
  bx_handletype handle,
  bx_ctbehtype behavior,			       /* @beh */
  bxppr_listtype * pList			       /* #RETURN "%s" */
  );

/*----------------------------------------------------------------------------*
 * BestXPprCTBehResultGet 
 * CLI abbrev.: pprctbehresultget prop = <resultprop>
 *
 * get permutation result for selected resultprop parameter 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprCTBehResultGet (	       /* @pprctbehresultget */
  bx_handletype handle,
  bxppr_behresulttype resultprop,		       /* @prop */
  bx_int32 * pValue				       /* #RETURN "%lu" */
 );

/*****************************************************************************
 * functions used internally
 *****************************************************************************/

#ifdef PPRX_EXPORTS

/*---------------------------------------------------------------------------*
 * bx_errtype PprCTBehProg ( bx_handletype handle,
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprCTBehProg ( bx_handletype handle,
			  bxppr_vardatatype * varData,
			  bxppr_behresultdatatype * behResult );

/*---------------------------------------------------------------------------*
 * bx_errtype PprCTBehResultCompute ( bxppr_behresultdatatype * behResult )
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprCTBehResultCompute ( bxppr_vardatatype * varData,
				   bxppr_behresultdatatype * behResult );

#endif /* defined PPRX_EXPORTS */


#ifdef __cplusplus
}
#endif


#endif /* defined __pxctbeh_H__ */
